/**
 * Controls all of the behaviour and interaction with a tool type card. These are
 * listed on the LTI tool type management page.
 *
 * See template: mod_lti/tool_card
 *
 * @module     mod_lti/tool_card_controller
 * @copyright  2015 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_lti/tool_card_controller",["jquery","core/ajax","core/notification","core/templates","core/modal_factory","mod_lti/tool_type","mod_lti/events","mod_lti/keys","core/str"],(function($,ajax,notification,templates,modalFactory,toolType,ltiEvents,KEYS,str){var SELECTORS_DELETE_BUTTON=".delete",SELECTORS_NAME_ELEMENT=".name",SELECTORS_DESCRIPTION_ELEMENT=".description",SELECTORS_CAPABILITIES_CONTAINER=".capabilities-container",SELECTORS_ACTIVATE_BUTTON=".tool-card-footer a.activate",getNameElement=function(element){return element.find(SELECTORS_NAME_ELEMENT)},getDescriptionElement=function(element){return element.find(SELECTORS_DESCRIPTION_ELEMENT)},getActivateButton=function(element){return element.find(SELECTORS_ACTIVATE_BUTTON)},getCapabilitiesContainer=function(element){return element.find(SELECTORS_CAPABILITIES_CONTAINER)},hasCapabilitiesContainer=function(element){return!!getCapabilitiesContainer(element).length},getTypeId=function(element){return element.attr("data-type-id")},clearAllAnnouncements=function(element){element.removeClass("announcement loading success fail capabilities")},startLoading=function(element){clearAllAnnouncements(element),element.addClass("announcement loading")},stopLoading=function(element){element.removeClass("announcement loading")},announceSuccess=function(element){var promise=$.Deferred();return clearAllAnnouncements(element),element.addClass("announcement success"),setTimeout((function(){element.removeClass("announcement success"),promise.resolve()}),2e3),promise},announceFailure=function(element){var promise=$.Deferred();return clearAllAnnouncements(element),element.addClass("announcement fail"),setTimeout((function(){element.removeClass("announcement fail"),promise.resolve()}),2e3),promise},setValueSnapshot=function(element,value){element.attr("data-val-snapshot",value)},getValueSnapshot=function(element){return element.attr("data-val-snapshot")},setStatusActive=function(element){var id=getTypeId(element);if(""===id)return $.Deferred().resolve();startLoading(element);var promise=toolType.update({id:id,state:toolType.constants.state.configured});return promise.then((function(toolTypeData){return stopLoading(element),announceSuccess(element),toolTypeData})).then((function(toolTypeData){return templates.render("mod_lti/tool_card",toolTypeData)})).then((function(html,js){templates.replaceNode(element,html,js)})).catch((function(){stopLoading(element),announceFailure(element)})),promise},registerEventListeners=function(element){var deleteButton=function(element){return element.find(SELECTORS_DELETE_BUTTON)}(element);deleteButton.click((function(e){e.preventDefault(),function(element){var promise=$.Deferred(),typeId=getTypeId(element);startLoading(element),""===typeId?$.Deferred().resolve():str.get_strings([{key:"delete",component:"mod_lti"},{key:"delete_confirmation",component:"mod_lti"},{key:"delete",component:"mod_lti"},{key:"cancel",component:"core"}]).done((function(strs){notification.confirm(strs[0],strs[1],strs[2],strs[3],(function(){toolType.delete(typeId).done((function(){stopLoading(element),announceSuccess(element).done((function(){element.remove()})).fail(notification.exception).always((function(){promise.resolve()}))})).fail((function(error){announceFailure(element),promise.reject(error)}))}),(function(){stopLoading(element),promise.resolve()}))})).fail((function(error){stopLoading(element),notification.exception(error),promise.reject(error)}))}(element)})),deleteButton.keypress((function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||e.keyCode!=KEYS.ENTER&&e.keyCode!=KEYS.SPACE||(e.preventDefault(),deleteButton.click())}));var descriptionElement=getDescriptionElement(element);descriptionElement.focus((function(e){e.preventDefault(),function(element){var descriptionElement=getDescriptionElement(element);if(!descriptionElement.hasClass("loading")){var description=descriptionElement.text().trim();setValueSnapshot(descriptionElement,description)}}(element)})),descriptionElement.blur((function(e){e.preventDefault(),function(element){var typeId=getTypeId(element);if(""===typeId)return $.Deferred().resolve();var descriptionElement=getDescriptionElement(element);if(descriptionElement.hasClass("loading"))return $.Deferred().resolve();var description=descriptionElement.text().trim();if(getValueSnapshot(descriptionElement)==description)return $.Deferred().resolve();descriptionElement.addClass("loading");var promise=toolType.update({id:typeId,description:description});promise.done((function(type){descriptionElement.removeClass("loading"),descriptionElement.text(type.description)})).fail(notification.exception),promise.fail((function(){descriptionElement.removeClass("loading")}))}(element)})),descriptionElement.keypress((function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||e.keyCode==KEYS.ENTER&&(e.preventDefault(),descriptionElement.blur())}));var nameElement=getNameElement(element);if(nameElement.focus((function(e){e.preventDefault(),function(element){var nameElement=getNameElement(element);if(!nameElement.hasClass("loading")){var name=nameElement.text().trim();setValueSnapshot(nameElement,name)}}(element)})),nameElement.blur((function(e){e.preventDefault(),function(element){var typeId=getTypeId(element);if(""===typeId)return $.Deferred().resolve();var nameElement=getNameElement(element);if(nameElement.hasClass("loading"))return $.Deferred().resolve();var name=nameElement.text().trim();if(getValueSnapshot(nameElement)==name)return $.Deferred().resolve();nameElement.addClass("loading");var promise=toolType.update({id:typeId,name:name});promise.done((function(type){nameElement.removeClass("loading"),nameElement.text(type.name)})),promise.fail((function(){nameElement.removeClass("loading")}))}(element)})),nameElement.keypress((function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||e.keyCode==KEYS.ENTER&&(e.preventDefault(),nameElement.blur())})),function(element){return!!getActivateButton(element).length}(element)){var activateButton=getActivateButton(element);activateButton.click((function(e){e.preventDefault(),function(element){hasCapabilitiesContainer(element)?function(element){element.addClass("announcement capabilities")}(element):setStatusActive(element)}(element)})),activateButton.keypress((function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||e.keyCode!=KEYS.ENTER&&e.keyCode!=KEYS.SPACE||(e.preventDefault(),activateButton.click())}))}if(hasCapabilitiesContainer(element)){var capabilitiesContainer=getCapabilitiesContainer(element);capabilitiesContainer.on(ltiEvents.CAPABILITIES_AGREE,(function(){setStatusActive(element)})),capabilitiesContainer.on(ltiEvents.CAPABILITIES_DECLINE,(function(){!function(element){element.removeClass("announcement capabilities")}(element)}))}};return{init:function(element){registerEventListeners(element),function(element){var trigger=$("#"+element.data("uniqid")+"-"+element.data("deploymentid")),context={uniqid:element.data("uniqid"),platformid:element.data("platformid"),clientid:element.data("clientid"),deploymentid:element.data("deploymentid"),urls:{publickeyset:element.data("publickeyseturl"),accesstoken:element.data("accesstokenurl"),authrequest:element.data("authrequesturl")}},bodyPromise=templates.render("mod_lti/tool_config_modal_body",context);context={mailto:"mailto:?subject="+encodeURIComponent(element.data("mailtosubject"))+"&body="+encodeURIComponent(element.data("platformidstr"))+":%20"+encodeURIComponent(element.data("platformid"))+"%0D%0A"+encodeURIComponent(element.data("clientidstr"))+":%20"+encodeURIComponent(element.data("clientid"))+"%0D%0A"+encodeURIComponent(element.data("deploymentidstr"))+":%20"+encodeURIComponent(element.data("deploymentid"))+"%0D%0A"+encodeURIComponent(element.data("publickeyseturlstr"))+":%20"+encodeURIComponent(element.data("publickeyseturl"))+"%0D%0A"+encodeURIComponent(element.data("accesstokenurlstr"))+":%20"+encodeURIComponent(element.data("accesstokenurl"))+"%0D%0A"+encodeURIComponent(element.data("authrequesturlstr"))+":%20"+encodeURIComponent(element.data("authrequesturl"))+"%0D%0A"};var footerPromise=templates.render("mod_lti/tool_config_modal_footer",context);modalFactory.create({large:!0,title:element.data("modaltitle"),body:bodyPromise,footer:footerPromise},trigger)}(element)}}}));

//# sourceMappingURL=tool_card_controller.min.js.map